# Cómo agregar un nuevo campo a usuarios en Laravel + Orchid

### Ejemplo: campo 'telefono' en la tabla users

---

## 1. Crear la migración

Crear el archivo de migración para agregar el campo:

```bash
php artisan make:migration add_telefono_to_users_table --table=users
```

En el archivo generado, modificar el método `up`:

```php
public function up()
{
    Schema::table('users', function (Blueprint $table) {
        $table->string('telefono')->nullable()->after('email');
    });
}
```

Y el método `down` para poder hacer rollback:

```php
public function down()
{
    Schema::table('users', function (Blueprint $table) {
        $table->dropColumn('telefono');
    });
}
```

Ejecutar la migración:

```bash
php artisan migrate
```

---

## 2. Agregar el campo al formulario de usuario en el dashboard

Editar el archivo:

- `app/Orchid/Layouts/User/UserEditLayout.php`

Agregar el input para teléfono:

```php
Input::make('user.telefono')
    ->type('text')
    ->max(255)
    ->title('Teléfono')
    ->placeholder('Número de teléfono'),
```

---

## 3. Habilitar asignación masiva en el modelo

Editar el archivo:

- `app/Models/User.php`

Agregar 'telefono' al array `$fillable`:

```php
protected $fillable = [
    'name',
    'email',
    'password',
    'telefono',
];
```

---

## 4. ¡Listo!

Ahora el campo aparecerá y se editará correctamente en el panel de administración de usuarios Orchid. Puedes realizar este proceso para cualquier nuevo campo que necesites agregar a la tabla `users` o cualquier otra tabla.
